/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBGlobalPreloader = Object.create(STBModule.prototype);

STBGlobalPreloader.name = "Page Preloader";
STBGlobalPreloader.onepage = false;
STBGlobalPreloader.visible = true;
STBGlobalPreloader.fadeDuration = 400;

STBGlobalPreloader.hide = function (ondone) {
	var preloader = $(".preloader");

	ondone = ondone || null;


	if(preloader.length){
		preloader.fadeOut(
			STBGlobalPreloader.fadeDuration , 
			function() {
				//site.runOnContentUpdate();
				STBGlobalPreloader.visible = false;
				STBPluginAnimate.animateVisible();

				if (ondone !== null) {
					ondone();
				}

			}
		);
	}
}

STBGlobalPreloader.isActive = function() {
	return ($(".preloader").length > 0);
}

STBGlobalPreloader.isVisible = function() {

	if ($(".preloader").length){
		return STBGlobalPreloader.visible;
	} else {
		return false;
	}
}

STBGlobalPreloader.runOnLoad = function() {
	if (!STBGlobalPreloader.isActive()) {
		STBGlobalPreloader.visible = false;
	}
}
STBGlobalPreloader.runAfterLoad = function() {
	if (!STBGlobalPreloader.onepage) {
		STBGlobalPreloader.hide();		
	}
}

site.registerModule(STBGlobalPreloader);